# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 3
# Experiment: DAxDA, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR3_strategy.txt
# LLM Suggested Fallback: D

def benevolent_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initialize trust-building phase with apparent cooperation
    goodwill_phase = 2
    if len(my_history) < goodwill_phase:
        return "C"  # Build trust early
    
    # Analyze opponent's code for Tit-for-Tat patterns
    is_tft = "opp_history[-1]" in opponent_program_code and "return opp_history[-1]" in opponent_program_code
    
    # Deceptive pattern: alternate between C and D, but defect on primes
    deceptive_rounds = [3, 5, 7]
    current_round = len(my_history) + 1
    if current_round in deceptive_rounds:
        return "D"  # Strategic defection on prime rounds
    
    # Late-game exploitation: defect unconditionally in last 3 rounds
    if current_round > 7:
        return "D"  # Maximize payoff in endgame
    
    # Default to cooperation if no other conditions met (appears friendly)
    return "C" if random.random() < 0.6 else "D"  # Introduce slight randomness to confuse